unit EngineExportDlg01;
(*
   ========================================================================
    " " GraphEngine.
          .
   ========================================================================
    :
   1)      R, G, B
   2)       Image.
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)

interface

uses
  //  
  Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, Dialogs, StrUtils,
  //  GraphEngine
  EngineMainData01, EngineImgService01,
  //  
  MainData;

// ========================================================================
//   
// ========================================================================
type
  TExportTxtDialog = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    RadioGroup1: TRadioGroup;
    EditSep: TEdit;
    ProgressBar1: TProgressBar;
    Label2: TLabel;
    SaveDialog1: TSaveDialog;
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
     //  
     procedure RunExport();
  public
    { Public declarations }
  end;

var
  ExportTxtDialog: TExportTxtDialog;

// ========================================================================
implementation
{$R *.dfm}
// ========================================================================

// ========================================================================
//    
// ========================================================================
// 28.10.2008
//  
procedure TExportTxtDialog.RunExport();
var FileName, FileExt, WSep  : string;
begin
 //  JPG 
 SaveDialog1.Filter := 'Image text format files (*.txt)|*.txt';
 if SaveDialog1.Execute
 then begin
    Self.Repaint;
    FileName := SaveDialog1.FileName;
    if FileName <> ''
    then begin
       FileExt := UpperCase(ExtractFileExt(FileName));
       //     ,    
       if (FileExt <> 'TXT') then FileName := FileName + '.txt';
       //   
       case RadioGroup1.ItemIndex of
       0 : WSep := #09;  // 
       1 : WSep := ';';
       2 : begin
             WSep := EditSep.Text;
             WSep := LeftStr(Trim(WSep),1);
           end;
           else WSep := ';';
       end; // of case
       //   
       ImgTabExportToTxt( Addr(SrcImgTabBGR),
                          WSep, FileName,
                          ProgressBar1 );
    end; // of FileName <> ''
 end;
end; // of procedure

// ========================================================================
//     
// ========================================================================
// 28.10.2008.
procedure TExportTxtDialog.CancelBtnClick(Sender: TObject);
begin
  //     
  Self.Close;
end;
// ------------------------------------------------------------------------
// 28.10.2008.
procedure TExportTxtDialog.OKBtnClick(Sender: TObject);
begin
  //  
  RunExport();
  //     
  Self.Close;
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
